C MAIN PROGRAM TO MINIMIZE A FUNCTION REPRESENTED BY ROUTINE CALCF
C
      PARAMETER (N = 10, LWORK = N*(N+10))
      DOUBLE PRECISION X0(N), X(N), F, WORK(LWORK), S, W
      EXTERNAL CALCF
C
C SPECIFY INITIAL ESTIMATE OF THE SOLUTION
C
      WRITE (*,*) 'COMPUTING...'
      DO 10 I = 1,N
         X0(I) = I / FLOAT(N+1)
10    CONTINUE
C
C MINIMIZE FUNCTION
C
      CALL UNCMND (N, X0, CALCF, X, F, IERROR, WORK, LWORK)
C
C PRINT RESULTS
C
      WRITE (*,*) 'UNCMND RESULTS'
      IF (IERROR .NE. 0) WRITE (*,*) ' ERROR CODE =', IERROR
      WRITE (*,'(1X,A,1X,D20.12)') ' F(X*) = ', F
      WRITE (*,*) ' X* ='
      WRITE (*,800) (X(I), I = 1,N)
C
      WRITE (*,*)
      WRITE (*,*) 'REFERENCE RESULTS FROM IBM PC/AT'
      WRITE (*,*) 'UNCMND WARNING -- INFO = 1: PROBABLY CONVERGED, GRADI
     *ENT SMALL'
      WRITE (*,*) 'UNCMND RESULTS'
      WRITE (*,*) ' ERROR CODE =           1'
      WRITE (*,*) ' F(X*) =    0.100000000000E+01'
      S=0.1D+1
      W=0.9999999D0
      WRITE (*,*) ' X* ='
      WRITE (*,799) S,S,S,S,S
      WRITE (*,799) S,S,S,S,W
C
      STOP
799   FORMAT (1X,D14.7,2X,D14.7,2X,D14.7,2X,D14.7,2X,D14.7)
800   FORMAT (1X,D14.7,2X,D14.7,2X,D14.7,2X,D14.7,2X,D14.7)
      END
C
C OBJECTIVE FUNCTION
C
      SUBROUTINE CALCF (N, X, F)
      DOUBLE PRECISION X(N), F, T1, T2
C
      T1 = 0.0
      T2 = 0.0
      DO 10 I = 2,N
         T1 = T1 + (X(I)-X(I-1)**2)**2
         T2 = T2 + (1.0-X(I-1))**2
10    CONTINUE
      F = 1.0 + 100.0*T1 + T2
C
      RETURN
      END
